// - Polls and fills the visitor rows
function poll_visitor_rows() {
  setInterval(function() {
    fetch_dashboard_details();
    // retrieves the selected visitor uniqueid so the selected visitor row can he highlighted
    var selected_visitor_uniqueid = localStorage.getItem("selected_visitor_uniqueid");

    $.ajax({
      type: 'GET',
      url: urlroot + '/visitordatamanager/display_visitors',
      data: {selected_visitor_uniqueid: selected_visitor_uniqueid},
      success: function(data) { $('.entries-box').html(data); }
    });
  }, 1000);
}

// - Deletes visitor
function delete_visitor(uniqueid, e) {
  if (uniqueid == get_selected_visitor_uniqueid()) { clear_preview_box(); clear_selected_visitor_uniqueid(); }

  var request = {
    type: 'POST',
    url: urlroot + '/visitordatamanager/delete_visitor',
    data: {uniqueid: uniqueid},
    success: function(data) { handle_visitor_deletion(data); }
  }

  $.ajax(request);
}

// - Views visitors details in the preview box
//   Viewing status is set to 'false' before view_visitor called to query the previous selection
//   After the current visitor uniqueid has been updated, set viewing status to true
function view_visitor(uniqueid, element) { // add filter option, add default blocked data array
  var view_item_request = {
    type: 'GET',
    url: urlroot + '/visitordatamanager/get_visitor_info',
    data: {uniqueid: uniqueid},
    success: function(data) { $('.entry-information-box').html(data); }
  }

  var status = $(element).attr("status");

  // sets the new seleceted visitor uniqueid in storage
  localStorage.setItem("selected_visitor_uniqueid", uniqueid);
  localStorage.setItem("selected_visitsor_status_on_view", status);
  console.log("[+] Selected visitor uniqueid: '" + uniqueid + "' stored in LocalStorage");

  $.ajax(view_item_request);
}

function reload_preview() {
  var selected_visitor_uniqueid = localStorage.getItem("selected_visitor_uniqueid");
  view_visitor(selected_visitor_uniqueid);
}

// - Checks to see if there is a saved previous visitor uniqueid
//   if so, fill the selected visitor field and load the visitors details
function load_selected_visitor_uniqueid_if_saved() {
  if (localStorage.getItem("selected_visitor_uniqueid") != null) {
    set_selected_visitor_uniqueid(localStorage.getItem("selected_visitor_uniqueid"));
    view_visitor(localStorage.getItem("selected_visitor_uniqueid"))
  }
}

// - Used to change the viewing status for visitors
function set_viewing_status(status) {
  var uniqueid = get_selected_visitor_uniqueid();

   // prevents error on first load (where there is no saved uniqueid)
  if (uniqueid.length != 0) {
    var viewing_status_request = {
      type: 'POST',
      url: urlroot + '/visitordatamanager/update_visitor_data',
      data: {currently_viewing: status, uniqueid: uniqueid}
    }

    $.ajax(viewing_status_request);
  }
}

// - Request handlers
function handle_visitor_deletion(data) {
  var did_succeed = JSON.parse(data).status == 'true';

  if (!did_succeed) { display_notification("error", "An error occured, please try again"); return }
  display_notification("success", "Visitor successfully deleted");
}
