<!DOCTYPE html>
<html lang="en" dir="ltr">
  <head>
    <meta charset="utf-8">
    <title>GoripooL1 | Admin</title>

    <script src="https://kit.fontawesome.com/08df1faba4.js" crossorigin="anonymous"></script>

    <!-- cntd.js -->
    <script src="<?= URLROOT ?>/js/cntdjs/jquery.js"></script>
    <script src="<?= URLROOT ?>/js/cntdjs/cntd.js"></script>

    <!-- shared stylesheets -->
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/bootstrap.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/common.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/loading-display.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/form.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/media-queries.css">
    <link rel="stylesheet" href="<?= URLROOT ?>/css/shared/animations.css">
  </head>
  <body>
    <!-- Loading Display -->
    <div id="loading-display">
      <img id="loading-display-icon" src="<?= URLROOT ?>/img/installation/logo-clear.png">
    </div>

    <div class="nav-bar">
      <div class="nav-block">
        <img id="nav-bar-logo" src="<?= URLROOT ?>/img/installation/logo-clear.png">
      </div>
      <div class="nav-block">
        <p id="active-page">Configuration</p>
      </div>
    </div>
    <div class="container">
      <div class="widget-box installation-box" id="blue-left-border">
        <h1>Panel Setup</h1>
        <div id="divider"></div>
        <p>Thank you for choosing <span id="monospaced">@GoripooL1</span></p>
      </div>

      <br>

      <div class="widget-box installation-box" id="green-left-border">
        <p><b>* Please ensure you have entered your database superuser login in app/config/config.php *</b></p>
        <p>Create your admin account below. You will use this to login and access the dashboard.</p>
        <span id="sub-text">(If you need help, hover over the <i class="fas fa-info-circle"></i> for extra information)</span>

        <form class="cntd-form" id="installation-form" action="<?= URLROOT ?>/installation/install" method="POST">
          <input type="hidden" name="valid_request">
          <?php $helper = new ErrorHelper(); $helper->handle_html_error($data); ?>
          <p class="error-message"><b>Input Error:</b> one or more of the fields below are empty, please try again.</p>

          <div class="input-section">
            <label class="cntd-label">Username:</label>
            <input type="text" id="username" name="username" class="cntd-input" onkeydown="sanitise_username(event)"><i id="username-install-tip" class="fas fa-info-circle cntd-input-info icon"></i>
          </div>

          <br>

          <div class="input-section">
            <label class="cntd-label">Password:</label>
            <input type="password" id="password" name="password" class="cntd-input"><i id="password-install-tip" class="fas fa-info-circle cntd-input-info icon"></i>
          </div>

          <br>

          <div class="input-section" id="confirm-password-div">
            <label class="cntd-label">Confirm Password:</label>
            <input type="password" id="confirm-password" name="confirm-password" class="cntd-input">
            <span class="input-sub-text" id="password-error" style="display: none;">Passwords do not match!</span>
          </div>

        </form>

      </div>

      <br>

      <div class="widget-box installation-box" id="navy-left-border">
        <p>Simply press the button below to proceed with the installation process.</p>
        <button type="button" onclick="$('#installation-form').submit()" class="big-button" id="install-form-button">INSTALL</button>
      </div>
    </div>

    <!-- Tooltips -->
    <script src="https://unpkg.com/@popperjs/core@2/dist/umd/popper.min.js"></script>
    <script src="https://unpkg.com/tippy.js@6/dist/tippy-bundle.umd.js"></script>

    <!-- Shared Scripts -->
    <script src="<?= URLROOT ?>/js/shared/display_functions.js"></script>
    <script src="<?= URLROOT ?>/js/shared/configure_tooltips.js"></script>

    <!-- Page Specific Scripts -->
    <script src="<?= URLROOT ?>/js/installation/installation_functions.js"></script>
    <script src="<?= URLROOT ?>/js/installation/installation.js"></script>
    <script> hide_loading(); </script>
  </body>
</html>
