<?php
class ErrorHelper {
  public $error_dictionary;

  public function __construct() {
    $this->error_dictionary = array(
      "table_installation_fail" => "An error occured while attempting to install the necessary SQL tables, please check your SQL user credentials and try again.",
      "installation_status_update_failure" => "An error occured while attempting to update the installation status, please check app/config/installed permission.",
      "installation_time_failure" => "An error occured while attempting to insert the installation timestamp.",
      "admin_account_creation_failure" => "An error occured while attempting to create an admin account, please check your SQL user credentials and try again.",
      "incorrect_login" => "The login was incorrect. Please try again.",
      "admin_setting_account_add_failure" => "admin_setting_account_add_failure"
    );
  }

  public function get_error_msg_from_code($error_code) {
    return $this->error_dictionary[$error_code];
  }

  public function check_action($controller, $action, $error_view, $error_code) {
    if (!$action) {
      $error_msg = $this->get_error_msg_from_code($error_code);
      $controller->view($error_view, ["error" => $error_msg]);
      die(0);
    }
  }

  public function handle_html_error($data) {
    if (isset($data['error']) && !empty($data)) {
      $error_msg = $data["error"];
      $error_template = "<p class='error-message' style='display: block'><b>Login Error:</b> $error_msg</p>";

      echo $error_template;
    }
  }

  public function handle_admin_setting_icon($data) {
    if (!isset($data["is_user_admin"])) { return; }

    if ($data["is_user_admin"] == 'true' && !empty($data)) {
      $admin_setting_icon_template = "<div class='nav-block icon-box' id='right'>
        <p class='icon'><i id='admin-settings-icon' class='fas fa-cog'></i></p>
      </div>";

      echo $admin_setting_icon_template;
    }
  }
}
?>
