<?php
// Device Details
function get_os_icon($useragent) {
  $os_platform = "Unknown OS";
  $all = array(
        '/windows nt 10/i'     =>  'fab fa-windows',
        '/windows nt 6.3/i'     =>  'fab fa-windows',
        '/windows nt 6.2/i'     =>  'fab fa-windows',
        '/windows nt 6.1/i'     =>  'fab fa-windows',
        '/windows nt 6.0/i'     =>  'fab fa-windows',
        '/windows nt 5.2/i'     =>  'fab fa-windows',
        '/windows nt 5.1/i'     =>  'fab fa-windows',
        '/windows xp/i'         =>  'fab fa-windows',
        '/windows nt 5.0/i'     =>  'fab fa-windows',
        '/windows me/i'         =>  'fab fa-windows',
        '/win98/i'              =>  'fab fa-windows',
        '/win95/i'              =>  'fab fa-windows',
        '/win16/i'              =>  'fab fa-windows',
        '/macintosh|mac os x/i' =>  'fab fa-apple',
        '/mac_powerpc/i'        =>  'fab fa-apple',
        '/linux/i'              =>  'fab fa-linux',
        '/ubuntu/i'             =>  'fab fa-ubtunu',
        '/iphone/i'             =>  'fab fa-apple',
        '/ipod/i'               =>  'fab fa-apple',
        '/ipad/i'               =>  'fab fa-apple',
        '/android/i'            =>  'fab fa-android',
        '/blackberry/i'         =>  'fab fa-blackberry',
        '/webos/i'              =>  'fab fa-apple');

  foreach ($all as $regex => $value) {
    if (preg_match($regex, $useragent)) {
      $os_platform = $value;
    }
  }
  return $os_platform;
}

function get_browser_icon($useragent) {
  $browser = "Unknown Browser";
  $all = array(
        '/msie/i'       =>  'fab fa-internet-explorer',
        '/firefox/i'    =>  'fab fa-firefox',
        '/safari/i'     =>  'fab fa-safari',
        '/chrome/i'     =>  'fab fa-chrome',
        '/edge/i'       =>  'fab fa-edge',
        '/opera/i'      =>  'fab fa-opera',
      );

    foreach ($all as $regex => $value) {
      if (preg_match($regex, $useragent)) {
        $browser = $value;
      }
    }
  return $browser;
}

function get_device_icons($useragent) {
  $os_icon = get_os_icon($useragent);
  $browser_icon = get_browser_icon($useragent);

  return array("os_icon" => $os_icon, "browser_icon" => $browser_icon);
}

// IP Details

function get_ip() {
  return $_SERVER["REMOTE_ADDR"];
}

function track_ip($ip) {
  $req_url = "http://ip-api.com/json/" . $ip;
  $response = json_decode(file_get_contents($req_url));

  $success = $response->{'status'} == 'success';

  if ($success) {
    $country = $response->{'country'};
    $city = $response->{'city'};

    return array("country" => $country, "city" => $city);
  }
}

function get_user_environment() {
  return get_ip() . ' | ' . getbrowser() . ' | ' . get_os() . ' | ' . $_SERVER["HTTP_USER_AGENT"];
}
?>
