<?php

/**
 * Database Class
 * This manages all database requests throughout the web app
 */

class Database {
  public $conn;
  private $table_name;

  /**
   * Connection Handlers
   * These handle the creation and descruction of the SQL connection
   */

  function __construct($server, $sql_user, $sql_pass, $database_name, $table_name) {
    $this->table_name = $table_name;
    $this->conn = mysqli_connect($server, $sql_user, $sql_pass, $database_name);
  }

  function __destruct() {
    mysqli_close($this->conn);
    die(0);
  }

  function get_conn() {
    return $this->conn;
  }

  /**
   * Query Executors
   * These handle the creation and execution of queries
   */

   /**
    * SELECT
    * Selects database information matching a condition
    * @param array $array -> linear list of items to be found
    * @param string $condition -> type of sql command
    */

  function select($params, $condition) {
    $param_string = implode(", ", $params);
    $query_string = "SELECT $param_string FROM $this->table_name $condition";

    $query = mysqli_query($this->conn, $query_string);
    return $this->perform_query($query_string, "SELECT");
  }

  /**
   * SELECT_ALL
   * Selects ALL database information without a condition
   * @param array $array -> linear list of items to be found
   */

  function select_all($params) {
    $param_string = implode(", ", $params);
    $query_string = "SELECT $param_string FROM $this->table_name";

    $query = mysqli_query($this->conn, $query_string);
    $rows = NULL;

    while ($row = mysqli_fetch_assoc($query)) {
      $rows[] = $row;
    }

    return $rows;
  }

  function select_all_with_condition($params, $condition) {
    $param_string = implode(", ", $params);
    $query_string = "SELECT $param_string FROM $this->table_name $condition";

    $query = mysqli_query($this->conn, $query_string);
    $rows = array();

    while ($row = mysqli_fetch_assoc($query)) {
      $rows[] = $row;
    }

    return $rows;
  }

  /**
   * UPDATE
   * @param array $array -> key value pairs to be updated
   * @param string $condition -> type of sql command
   */


  function update($params, $condition) {
    $param_string = NULL;

    foreach ($params as $field => $data) {
        $param_string .= "`$field`='$data', ";
    }

    $param_string = substr($param_string, 0, -2); // clears last ', ' to prevent SQL syntax error
    $query_string = "UPDATE $this->table_name SET $param_string $condition";

    return $this->perform_query($query_string, "UPDATE");
  }

  /**
   * INSERT
   * @param array $array -> key value pairs to be inserted
   * @param string $condition -> type of sql command
   */

  function insert($params) {
    $fields_string = "(";
    $values_string = ") VALUES (";

    foreach ($params as $field => $_) {
      $fields_string .= "$field, ";
    }

    foreach ($params as $_ => $data) {
      $values_string .= "'$data', ";
    }



    $query_string = "INSERT INTO $this->table_name" . substr($fields_string, 0, -2) . substr($values_string, 0, -2) . ")";

    return $this->perform_query($query_string, "INSERT");
  }

  function run_query($query) {
    return mysqli_query($this->conn, $query);
  }

  /**
   * DELETE
   * @param array $array -> key value pairs to be inserted
   * @param string $condition -> type of sql command
   */

   function delete($condition) {
     $query_string = "DELETE FROM $this->table_name $condition";

     $query = mysqli_query($this->conn, $query_string);
     return $this->perform_query($query_string, "DELETE");
   }

  /**
   * GET_ROWS
   * @param array $array -> key value pairs to be inserted
   * @param string $condition -> type of sql command
   */

   function get_rows() {
     $rows = mysqli_num_rows(mysqli_query($this->conn, "SELECT * FROM $this->table_name"));

     return $rows;
   }

  /**
   * SQL Utilities
   * These assist with the query executors functions
   */

  function perform_query($query_string, $query_type) {
    $query = mysqli_query($this->conn, $query_string);

    if (!$query) {
      $error = mysqli_error($this->conn);
      echo $error;
      return false;
      die(0);
    }

    if ($query_type == "SELECT") {
      $response = $this->parse_results($query);
    } else {
      $response = $query;
    }

    return $response;
  }

  function parse_results($query) {
    $query_response = array();

    $results = mysqli_fetch_array($query);

    if ($results != NULL) {
      foreach ($results as $result) {
        array_push($query_response, $result);
      }
    }

    return $results;
  }
}

?>
