<?php
class Controller {
  // Store all helpers for controller children to use
  public $error_helper;
  public $installation_helper;
  public $redirection_helper;
  public $request_helper;
  public $element_helper;

  public function __construct() {
    $this->error_helper = new ErrorHelper;
    $this->installation_helper = new InstallationHelper;
    $this->redirection_helper = new RedirectionHelper;
    $this->request_helper = new RequestHelper;
    $this->element_helper = new ElementHelper;
  }

  public function model($model) {
    require_once '../app/models/' . $model . '.php';
    return new $model();
  }

  public function view($view, $data = []) {
    if (file_exists('../app/views/' . $view . '.php')) {
      require_once '../app/views/' . $view . '.php';
      return;
    }

    die("View: $view does not exist");
  }
}
