<?php
class PreviewFilter extends Controller {
  const VISITOR_TABLE_NAME = 'visitors';

  protected $selected_column_session = "selected_preview_columns";

  protected $information_schema_database;
  protected $visitor_table_columns = array();

  function __construct() {
    Controller::__construct();

    $this->information_schema_database = new Database("localhost", SQL_USER_NAME, SQL_USER_PASS, "information_schema", "columns");

    // set the total and select column arrays
    $this->set_visitor_table_columns_array();
    $this->set_selected_preview_column_session();
  }

  // retreives the columns from the visitor table and
  // stores in array for preview comparison
  function set_visitor_table_columns_array() {
    $table_name = $this::VISITOR_TABLE_NAME;
    $query_condition = "WHERE TABLE_NAME='$table_name'";

    $table_columns = $this->information_schema_database->select_all_with_condition(array("COLUMN_NAME"), $query_condition);

    foreach ($table_columns as $column) {
      $column_name = $column["COLUMN_NAME"];

      array_push($this->visitor_table_columns, $column_name);
    }
  }

  // stores the selected preview columns into a session var (so admin panel can read it)
  // if not set, then by default set all the columns as selected
  // if set, nothing needs to be done
  function set_selected_preview_column_session() {
    if (!isset($_SESSION[$this->selected_column_session])) {
      $_SESSION[$this->selected_column_session] = DEFAULT_SELECTED_PROPERTIES;
    }
  }

  // handles the process of selecting or deselecting a column in the preview filter
  function change_preview_value_status() {
    $this->request_helper->only_allow_ajax_call();
    $this->request_helper->only_allow_post_request();

    $correct_method = $_POST["is_column_checked"] == 'false' ? $this->deselect_preview_column($_POST["linked_column"]) : $this->select_preview_column($_POST["linked_column"]);
  }

  function select_preview_column($column) {
    $selected_columns = $_SESSION[$this->selected_column_session];

    if (!in_array($column, $selected_columns)) {
      array_push($_SESSION[$this->selected_column_session], $column);
    }
  }

  function deselect_preview_column($column) {
    $selected_columns = $_SESSION[$this->selected_column_session];
    $new_array = array();

    if (in_array($column, $selected_columns)) {
      foreach ($selected_columns as $selected_column) {
        if ($selected_column != $column) {
          array_push($new_array, $selected_column);
        }
      }
    }

    $_SESSION[$this->selected_column_session] = $new_array;
  }

  function build() {
    $skeleton = "";

    foreach ($this->visitor_table_columns as $table_column) {
      $is_checked = in_array($table_column, $_SESSION[$this->selected_column_session]) ? "checked" : "";

      $skeleton .= "
      <div>
        <input type='checkbox' onclick='change_preview_value_status(this)' linked_column='$table_column' $is_checked> <label>$table_column</label>
      </div>
      ";
    }

    echo $skeleton;
  }
}
?>
