<?php
class Installation extends Controller {
  protected $installation_model;
  protected $user_model;

  public function __construct() {
    Controller::__construct();
    $this->initiate_models();
  }

  protected function initiate_models() {
    $this->installation_model = $this->model("InstallationModel");
    $this->user_model = $this->model("UserModel");
  }

  public function index() {
    if (!$this->installation_helper->is_installed()) {
      $this->view("installation/install");
      die(0);
    }

    $this->redirection_helper->send_to_login();
  }

  public function install() {
    $this->request_helper->only_allow_post_request();
    if ($this->installation_helper->is_installed()) { $this->redirection_helper->send_to_login(); die(0); } // failsafe incase unsafe reinstallation

    $installation_attempt = $this->installation_model->install_database_tables();
    $this->error_helper->check_action($this, $installation_attempt, "installation/install", "table_installation_fail");

    $admin_account_creation = $this->user_model->add_user($_POST["username"], $_POST["password"], 1);
    $this->error_helper->check_action($this, $admin_account_creation, "installation/install", "admin_account_creation_failure");

    $installation_status_update = $this->installation_model->change_installed_status(1);
    $this->error_helper->check_action($this, $installation_status_update, "installation/install", "installation_status_update_failure");

    $set_installation_time = $this->installation_model->set_installation_time();
    $this->error_helper->check_action($this, $set_installation_time, "installation/install", "installation_time_failure");

    $this->user_model->begin_login_session();
    $this->user_model->set_active_user_username($_POST["username"]);
    $this->redirection_helper->send_to_login();
    die(0);
  }
}
 ?>
